<header class="bg-white shadow-sm border-b border-gray-200 z-20">
    <div class="flex items-center justify-between px-4 md:px-6 py-4">
        <!-- Mobile Menu Button & Logo -->
        <div class="flex items-center space-x-4">
            <button onclick="toggleSidebar()" class="md:hidden text-gray-600 hover:text-orange-600">
                <i class="fas fa-bars text-xl"></i>
            </button>

            <div class="hidden md:block">
                <h1 class="text-xl font-bold text-gray-800">@yield('page-title', 'Dashboard')</h1>
                <p class="text-sm text-gray-500">@yield('page-subtitle', 'Admin Panel')</p>
            </div>
        </div>

        <!-- Right Side -->
        <div class="flex items-center space-x-4">
            <!-- Notifications -->
            @php
                $unreadCount = auth()->user()->notifikasi()->forMode()->where('is_read', false)->count();
            @endphp

            <div class="relative">
                <a href="{{ route('notifikasi.index') }}"
                    class="relative text-gray-600 hover:text-orange-600 transition {{ request()->routeIs('notifikasi.index') ? 'text-orange-600' : '' }}">
                    <i class="fas fa-bell text-xl"></i>
                    @if ($unreadCount > 0)
                        <span
                            class="absolute -top-1 -right-1 bg-red-500 text-white text-xs
                                     rounded-full min-w-[18px] h-[18px]
                                     flex items-center justify-center px-1 font-bold">
                            {{ $unreadCount > 99 ? '99+' : $unreadCount }}
                        </span>
                    @endif
                </a>
            </div>

            <!-- User Dropdown -->
            <div class="relative group">
                <button onclick="toggleUserMenu()"
                    class="flex items-center space-x-3 hover:bg-gray-100 rounded-lg px-3 py-2 transition">
                    <div
                        class="w-10 h-10 rounded-full gradient-orange flex items-center justify-center text-white font-semibold">
                        {{ substr(auth()->user()->nama, 0, 1) }}
                    </div>
                    <div class="hidden md:block text-left">
                        <p class="text-sm font-semibold text-gray-800">{{ auth()->user()->nama }}</p>
                        <p class="text-xs text-gray-500">Administrator</p>
                    </div>
                    <i class="fas fa-chevron-down text-xs text-gray-600"></i>
                </button>

                <!-- Dropdown Menu -->
                <div id="userMenu"
                    class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg border border-gray-200 py-2 hidden z-50">
                    <hr class="my-2">
                    <form action="{{ route('logout') }}" method="POST">
                        @csrf
                        <button type="submit"
                            class="w-full flex items-center px-4 py-2 text-sm text-red-600 hover:bg-red-50">
                            <i class="fas fa-sign-out-alt mr-3"></i>
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</header>
